/***************************************************************************************
 * Project  :
 * Experimental Platform :Raspberry Pi 4B + 8-ch Relay Board
 * Hardware Connection :Raspberry Pi 4B -> 8-ch Relay Board in wiringpi number
 *		P22  --> CH1
 *		P23  --> CH2
 *		P24  --> CH3
 *		P25  --> CH4
 *		P26  --> CH5
 *		P27  --> CH6
 *		P28  --> CH7
 *		P29  --> CH8
 * Author		   : Andy Li
 * Web Site		   : www.seengreat.com
***************************************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>		
#include <wiringPi.h>

//the following pin definiting use wiringpi
#define PIN_CH1      22
#define PIN_CH2      23
#define PIN_CH3      24
#define PIN_CH4      25
#define PIN_CH5      26
#define PIN_CH6      27
#define PIN_CH7      28
#define PIN_CH8      29


#define STATE_ON     LOW
#define STATE_OFF    HIGH

void relay_control(int ch, int state)
{
	if (ch == 1)
		digitalWrite(PIN_CH1, state);
	else if (ch == 2) 
		digitalWrite(PIN_CH2, state);
	else if (ch == 3)
		digitalWrite(PIN_CH3, state);
	else if (ch == 4) 
		digitalWrite(PIN_CH4, state);
	else if (ch == 5)
		digitalWrite(PIN_CH5, state);
	else if (ch == 6) 
		digitalWrite(PIN_CH6, state);
	else if (ch == 7)
		digitalWrite(PIN_CH7, state);
	else if (ch == 8)
		digitalWrite(PIN_CH8, state);
}
 
int main(void)
{
	printf("\r\n-- 8-ch relay demo --\r\n");
	printf("Raspberry Pi 4B\r\n");
  printf("Init gpio for wiringpi\r\n");
    if(wiringPiSetup() < 0)//use wiringpi Pin number
    { 
        printf("wiringPi lib init failed! \r\n");
    } 
    pinMode(PIN_CH1, OUTPUT);
    pinMode(PIN_CH2, OUTPUT);
    pinMode(PIN_CH3, OUTPUT);
		pinMode(PIN_CH4, OUTPUT);
    pinMode(PIN_CH5, OUTPUT);
    pinMode(PIN_CH6, OUTPUT);
		pinMode(PIN_CH7, OUTPUT);
    pinMode(PIN_CH8, OUTPUT);

	while(1)
	{		
        printf("ch1 relay on\r\n");
        relay_control(1, STATE_ON);
        delay(1000);
        printf("ch1 relay off\r\n");
        relay_control(1, STATE_OFF);
		
        printf("ch2 relay on\r\n");
        relay_control(2, STATE_ON);
        delay(1000);
        printf("ch2 relay off\r\n");
        relay_control(2, STATE_OFF);
		
        printf("ch3 relay on\r\n");
        relay_control(3, STATE_ON);
        delay(1000);
        printf("ch3 relay off\r\n");
        relay_control(3, STATE_OFF);
		
        printf("ch4 relay on\r\n");
        relay_control(4, STATE_ON);
        delay(1000);
        printf("ch4 relay off\r\n");
        relay_control(4, STATE_OFF);
		
		
		    printf("ch5 relay on\r\n");
        relay_control(5, STATE_ON);
        delay(1000);
        printf("ch5 relay off\r\n");
        relay_control(5, STATE_OFF);
				
				
				printf("ch6 relay on\r\n");
        relay_control(6, STATE_ON);
        delay(1000);
        printf("ch6 relay off\r\n");
        relay_control(6, STATE_OFF);
				
				printf("ch7 relay on\r\n");
        relay_control(7, STATE_ON);
        delay(1000);
        printf("ch7 relay off\r\n");
        relay_control(7, STATE_OFF);
				
				
				printf("ch8 relay on\r\n");
        relay_control(8, STATE_ON);
        delay(1000);
        printf("ch8 relay off\r\n");
        relay_control(8, STATE_OFF);
	} 
			 
}

